﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class ReportComprehensiveVhaSummary : System.Web.UI.Page
{

    #region Variable Declarations

    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser;
    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();
    string _reportName = "ReportComprehensiveVhaSummary";

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (AccessAllowed())
            {
                string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
                UserAccountManager _currentUser1 = (UserAccountManager)HttpContext.Current.User;

                ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser1.FullName);
                ReportViewer1.Reset();
                _reportParameters.Clear();
                _reportParameters.Add(reportParamUsername);
                ReportViewer1.ServerReport.ReportPath = _reportName;
                ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

                if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                {
                    ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                    //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
                }
                ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());
                ReportViewer1.ProcessingMode = ProcessingMode.Remote;
                ReportViewer1.Visible = true;
                ReportViewer1.ServerReport.Refresh();
            }
            else
            {
                Response.Redirect("ErrorPage.aspx?id=100");
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100021", "Get() ReportData");
        }
    }

    #endregion

    #region Public Methods

    public bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return _currentUser.IsInRole(16);
    }

    #endregion

}
